<?php
// update_category.php
require_once 'db_connect.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. Get data from Android (Using keys defined in ApiInterface)
    // Note: Use isset() to prevent warnings if a field is missing
    $id = isset($_POST['id']) ? $_POST['id'] : 0;
    $name = isset($_POST['name']) ? $_POST['name'] : '';
    $imagePath = isset($_POST['image_path']) ? $_POST['image_path'] : '';
    $bestDeal = isset($_POST['best_deal']) ? $_POST['best_deal'] : 0; 

    // 2. SQL Update Query
    // Mapping: 
    // Android 'image_path' -> DB 'image_url'
    // Android 'best_deal'  -> DB 'best_deal'
    $sql = "UPDATE categories SET name = ?, image_url = ?, best_deal = ? WHERE id = ?";
    
    if ($stmt = $conn->prepare($sql)) {
        // Bind parameters: 
        // s = name (String)
        // s = image_url (String)
        // i = best_deal (Int)
        // i = id (Int)
        $stmt->bind_param("ssii", $name, $imagePath, $bestDeal, $id);
        
        if ($stmt->execute()) {
             echo json_encode(array("status" => "success", "message" => "Updated successfully"));
        } else {
             echo json_encode(array("status" => "error", "message" => "SQL Error: " . $stmt->error));
        }
        $stmt->close();
    } else {
        echo json_encode(array("status" => "error", "message" => "Prepare Error: " . $conn->error));
    }

} else {
    echo json_encode(array("status" => "error", "message" => "Invalid Request"));
}
$conn->close();
?>