<?php
header('Content-Type: application/json');

// --- 1. INCLUDE DATABASE CONNECTION ---
// This file provides both $conn (MySQLi) and $pdo (PDO)
require_once 'db_connect.php'; 

$response = [];

// --- 2. FETCH THE LATEST NOTICE ---
// Uses the $conn object initialized in db_connect.php
$sql = "SELECT notice FROM notices ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $response['notice'] = $row['notice'];
} else {
    // Provide a default message if no notice is found
    $response['notice'] = 'Welcome to Splashjet Ink BD!';
}

// --- 3. OUTPUT JSON ---
echo json_encode($response);

// --- 4. CLOSE CONNECTION ---
$conn->close();
?>