<?php
// get_brands.php - Fetches all brands using centralized connection

// --- SETUP: ENABLE ERROR REPORTING & SET HEADER ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- 1. & 2. INCLUDE DATABASE CONNECTION ---
// This file provides the $pdo object needed for the query below
require_once 'db_connect.php'; 

try {
    // --- 3. FETCH DATA ---
    // Fetch all brands, ordering by name alphabetically
    $stmt = $pdo->query("SELECT id, name, image_url FROM brands ORDER BY name ASC");
    $brands = $stmt->fetchAll();

    // Return the brands as a JSON array
    echo json_encode($brands);

} catch (PDOException $e) {
    // If a database error occurs, return an empty JSON array
    // This keeps the app stable even if the table has issues.
    echo json_encode([]);
}
?>