<?php
// get_banners.php - Fetches all banners using centralized connection

// --- SETUP: ENABLE ERROR REPORTING & SET HEADER ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- 1. & 2. INCLUDE DATABASE CONNECTION ---
// This file provides the $pdo object
require_once 'db_connect.php'; 

try {
    // --- 3. FETCH DATA ---
    // Fetch all banners, newest first
    $stmt = $pdo->query("SELECT id, image_url, title FROM banners ORDER BY created_at DESC");
    $banners = $stmt->fetchAll();

    // Return the banners as a JSON array
    echo json_encode($banners);

} catch (PDOException $e) {
    // In case of a database error, return an empty JSON array
    // This keeps the app stable if the table hasn't been created yet.
    echo json_encode([]);
}
?>