<?php
// delete_banner.php - Deletes a banner using centralized connection

ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- 1. & 2. INCLUDE DATABASE CONNECTION ---
// This file provides the $pdo object
require_once 'db_connect.php'; 

// --- 3. GET BANNER ID FROM APP ---
if (!isset($_POST['id'])) {
    die(json_encode(['status' => 'error', 'message' => 'Banner ID is missing.']));
}
$banner_id = $_POST['id'];

// --- 4. DELETE FROM DATABASE ---
try {
    // We use the $pdo object from db_connect.php
    $sql = "DELETE FROM banners WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    // Execute the delete operation
    if ($stmt->execute([$banner_id])) {
        // rowCount() checks if the record existed before deletion
        if ($stmt->rowCount() > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Banner deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Banner not found or already deleted.']);
        }
    }
} catch (PDOException $e) {
    // Catches SQL issues like table name errors or connection drops
    echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
}
?>