<?php
// FINAL SCRIPT: add_product.php (with is_featured and is_active)

ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 0); 
ini_set('log_errors', 1);

require 'db_connect.php'; 

header('Content-Type: application/json');
$response = [];

ob_clean(); 

if (!isset($conn) || $conn->connect_error) {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: Database connection is not available.';
    echo json_encode($response);
    exit; 
}

$required_fields = ['name', 'category', 'brand_id', 'models', 'description', 'specification', 'regular_price', 'offer_price', 'image_path'];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || trim($_POST[$field]) === '') {
        http_response_code(400); 
        $response['status'] = 'error';
        $response['message'] = "Required field '{$field}' is missing or empty.";
        echo json_encode($response);
        exit;
    }
}

// --- Assign and Sanitize Data ---
$name = trim($_POST['name']);
$category = trim($_POST['category']);
$brand_id = (int)$_POST['brand_id'];
$models = trim($_POST['models']);
$description = trim($_POST['description']);
$specification = trim($_POST['specification']);
$regular_price = (float)$_POST['regular_price'];
$offer_price = (float)$_POST['offer_price'];
$image_path = trim($_POST['image_path']); 
$gallery_images = isset($_POST['gallery_images']) ? trim($_POST['gallery_images']) : ''; 
$is_featured = isset($_POST['is_featured']) ? (int)$_POST['is_featured'] : 0;
// --- NEW ---
$is_active = isset($_POST['is_active']) ? (int)$_POST['is_active'] : 1; // Default to 1 (active)

// --- UPDATED SQL ---
$sql = "INSERT INTO products (name, category, brand_id, models, description, specification, regular_price, offer_price, image_url, gallery_images, is_featured, is_active) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // --- UPDATED BIND_PARAM ---
    $stmt->bind_param(
        "ssisssddssii", 
        $name, 
        $category, 
        $brand_id, 
        $models, 
        $description, 
        $specification, 
        $regular_price, 
        $offer_price, 
        $image_path,
        $gallery_images,
        $is_featured,
        $is_active // --- NEW ---
    );

    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = 'Product added successfully.';
    } else {
        http_response_code(500);
        $response['status'] = 'error';
        $response['message'] = 'Server Error: Could not save the product.';
    }
    $stmt->close();
} else {
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Server Error: Could not prepare the database statement.';
}

$json_output = json_encode($response);
ob_clean(); 
echo $json_output;

$conn->close();
exit; 
?>