<?php
// add_offer.php

ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- Include the updated connection file ---
require_once 'db_connect.php'; 

// --- GET DATA FROM APP ---
if (!isset($_POST['title']) || !isset($_POST['image_path'])) {
    die(json_encode(['status' => 'error', 'message' => 'Required fields missing.']));
}

$title = $_POST['title'];
$image_path = $_POST['image_path'];
$description = $_POST['description'] ?? '';
$start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
$end_date = !empty($_POST['end_date']) ? $_POST['end_date'] : null;

// --- INSERT INTO DATABASE ---
try {
    // $pdo is provided by db_connect.php
    $sql = "INSERT INTO offers (title, image_url, description, start_date, end_date) VALUES (?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$title, $image_path, $description, $start_date, $end_date]);

    echo json_encode(['status' => 'success', 'message' => 'Offer data saved successfully.']);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
}