<?php
require 'db_connect.php';

$id = isset($_POST['id']) ? $_POST['id'] : '';
$title = isset($_POST['title']) ? $_POST['title'] : '';
$message = isset($_POST['message']) ? $_POST['message'] : '';
$imageUrl = isset($_POST['image_url']) ? $_POST['image_url'] : NULL;

$response = array();

if (empty($id) || empty($title) || empty($message)) {
    $response['status'] = 'error';
    $response['message'] = 'ID, title, and message are required.';
} else {
    $stmt = $conn->prepare("UPDATE notifications SET title = ?, message = ?, image_url = ? WHERE id = ?");
    $stmt->bind_param("sssi", $title, $message, $imageUrl, $id);

    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = 'Notification updated successfully.';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Failed to update notification: ' . $stmt->error;
    }
    $stmt->close();
}

header('Content-Type: application/json');
echo json_encode($response);

$conn->close();
?>
