<?php
// get_offers.php - Fetches all offers using centralized connection

// --- SETUP: ENABLE ERROR REPORTING & SET HEADER ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- 1. & 2. INCLUDE DATABASE CONNECTION ---
// This file provides the $pdo object needed for the query below
require_once 'db_connect.php'; 

try {
    // --- 3. FETCH DATA ---
    // Fetch all offers, including the date fields, ordered by end date
    $stmt = $pdo->query("SELECT id, title, image_url, description, start_date, end_date FROM offers ORDER BY end_date DESC");
    $offers = $stmt->fetchAll();

    // Return the offers as a JSON array
    echo json_encode($offers);

} catch (PDOException $e) {
    // If the table doesn't exist or another DB error occurs, return an empty JSON array.
    // This prevents the app from crashing.
    echo json_encode([]);
}
?>