<?php
// delete_slider.php

header('Content-Type: application/json');
require 'db_connect.php';

$response = ['status' => 'error', 'message' => 'Invalid request.'];

// Check if the 'image_url' field was sent from the app
if (isset($_POST['image_url'])) {
    
    $imageUrl = $_POST['image_url'];

    $sql = "DELETE FROM sliders WHERE image_url = ?";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        $stmt->bind_param("s", $imageUrl);
        
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                $response['status'] = 'success';
                $response['message'] = 'Slider deleted successfully.';
            } else {
                // This can happen if the image was already deleted or not found
                $response['status'] = 'error';
                $response['message'] = 'No slider found with the given image URL.';
            }
        } else {
            $response['message'] = 'Database error: Failed to execute delete statement. ' . $stmt->error;
        }
        $stmt->close();
    } else {
        $response['message'] = 'Database error: Could not prepare statement. ' . $conn->error;
    }
} else {
    $response['message'] = "Required 'image_url' field is missing from the request.";
}

// Send the final response back to the app
echo json_encode($response);
$conn->close();
?>