<?php
// Set the content type to JSON
header('Content-Type: application/json');

// IMPORTANT: Update this path to your actual uploads directory on the server.
// It should be the server path, not the URL.// For example: 'uploads/' or 'public_html/uploads/'
$base_upload_dir = 'uploads/'; // <--- CHANGE THIS!

// Default response
$response = ['status' => 'error', 'message' => 'Invalid request.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['image_url']) && !empty($_POST['image_url'])) {
        $imageUrl = $_POST['image_url'];

        // Security: Use basename() to prevent directory traversal attacks.
        // This extracts just the filename from the full URL.
        $filename = basename($imageUrl);
        
        // Construct the full path to the file on the server's filesystem.
        $filePath = $base_upload_dir . $filename;

        if (file_exists($filePath)) {
            // Attempt to delete the file.
            if (unlink($filePath)) {
                $response = ['status' => 'success', 'message' => 'Image deleted successfully.'];
            } else {
                // This can happen if the server script doesn't have permission to delete files.
                $response = ['status' => 'error', 'message' => 'Could not delete the file. Check server permissions.'];
            }
        } else {
            $response = ['status' => 'error', 'message' => 'File not found on the server.'];
        }
    } else {
        $response = ['status' => 'error', 'message' => 'No image_url was provided.'];
    }
}

// Send the final JSON response back to the Android app.
echo json_encode($response);
?>